%  Progetto Metodo di Gauss con Pivoting Parziale
%
%             Programma elaborato da
%
%      Giovanni DI CECCA & Virginia BELLINO
%           50 / 887           408 / 466
%
%             http://www.dicecca.net

% Funzione di Back Substitution

% SCOPO: la funzione ha lo scopo di calcolare i valori delle incognite mediante sostituzione all'indietro
%
% Parametri di Input: n = righe della matrice
%                     A = matrice triangolarizzata
%                     pivot = Vettore colonna che contiene gli scambi eseguiti sulla matrice
%                     B = Vettore colonna dei termini noti modificati
%
% Parametri di Output: x = Vettore colonna con i risultati

function [x]=bsLPU(n,A,pivot,B)

% Calcolo dell'ultima riga della matrice
x(n,1)=B(pivot(n),1)/A(pivot(n),n);

% Ciclo della funzione di sostituzione all'indietro partendo dalla penultima riga fino alla prima
for i=n-1:-1:1
    
    % Inizializzazione della variabile somma
    somma = 0;
    
    % Calcolo delle incoglie per sostitutzione
    for k=(i+1):n
        somma = somma + A(pivot(i),k) * x(k,1);
    end
    
    % Calcolo del valore delle incognite
    x(i,1)=(B(pivot(i),1)-somma)/A(pivot(i),i);
    
end

