%  Progetto Metodo di Gauss con Pivoting Parziale
%
%             Programma elaborato da
%
%      Giovanni DI CECCA & Virginia BELLINO
%           50 / 887           408 / 466
%
%             http://www.dicecca.net


% Routine dei controlli sulla matrice A e vettore colonna B

% SCOPO: La funzione fa il controllo sulla matrice A e vettore colonna B
%
% Parametri di Input: Matrice A, Vettore colonna B
%
% Parametri di Output: iflag = Flag di controllo sugli errori
%                           0 = OK
%                           1 = Matrice non quadrata
%                           2 = Il vettore colonna dei termini noti non  uguale alla matrice
%                           3 = B  un vettore colonna non una matrice

function iflag=errore(A,B)

% Associa alla variabile matrix la lunghezza e larghezza della matrice A
matrix=size(A);

% Controllo sulla quadratura della matrice
if matrix(1)==matrix(2)
    
    iflag = 0; % Flag di controllo 0 = OK
    
else
    
    iflag = 1; % Matrice non quadrata
    break
end

% calcola la dimensione del vettore colonna
vectorcln=size(B);

% Controllo sul vettore colonna b, il numero delle righe di b deve essere
% uguale a quello della matrice A
if matrix(1)==vectorcln(1)
    
    iflag = 0; % Flag di controllo 0 = Ok
else

    iflag = 2; % Il vettore colonna dei termini noti non ha dimensione uguale alla matrice
    break
end

% Controllo sul vettore colonna b, il numero delle colonne deve essere 1
if vectorcln(2)==1
    iflag = 0; % Flag di controllo 0 = Ok
    
else
    
    iflag = 3; % B  un vettore colonna non una matrice
    break
end