%  Progetto Metodo di Gauss con Pivoting Parziale
%
%             Programma elaborato da
%
%      Giovanni DI CECCA & Virginia BELLINO
%           50 / 887           408 / 466
%
%             http://www.dicecca.net

% funzione maximus

% SCOPO: la funzione ha lo scopo di calcolare il massimo della colonna k selezionata, salvamdone valore e indice
%
% Parametri di Input: A = matrice
%                     k = Passo dell'algoritmo
%                     pivot = Vettore colonna che contiene gli scambi della matrice
%                     n = Dimensione della matrice
%
% Parametri di Output: max = massimo trovato
%                      ip = Indice del massimo trovato 

% Funzione che trova l'elemento massimo in val. assoluto sulla colonna k e riga da k+l ad n
function [max,ip]=maximus(A,k,pivot,n)

% Sulla colonna selezionata si ricerca il massimo in valore assoluto,salvandone valore e indice
max = abs(A(pivot(k),k));
   
ip = k;    % ip sta per indice del massimo
   
for p=k+1:n
    
    if (abs(A(pivot(p),k))>max)
        % memorizza temporaneamente il valore del massimo 
        % della colonna k al di sotto della diagonale principale  e del suo indice

        max = abs(A(pivot(p),k));
        
        ip = p;
    end
      
end
