%  Progetto Metodo di Gauss con Pivoting Parziale
%
%             Programma elaborato da
%
%      Giovanni DI CECCA & Virginia BELLINO
%           50 / 887           408 / 466
%
%             http://www.dicecca.net

% Funzione Main

% SCOPO: la funzione esegue la risoluzione di un sistema 
% di equazioni lineari del tipo Ax = b utilizzando 
% il metodo di eliminazione di Gauss con pivoting parziale

% Parametri di input:
% A: matrice dei coefficienti del sistema lineare. E' di dimensione n*n.
% B: vettore dei termini noti. E' di dimensione n.

% Parametri di output:
% A: matrice dei coefficienti  modificata.
% B: vettore dei termini noti modificati.
% pivot: vettore che registra gli scambi effettuati durante il pivoting.
% det: determinante della matrice.
% iflag: indicatore di errori.
% x: vettore contenente le soluzioni finali del sistema.
                     

function [A,B,pivot,det,iflag,x]=myGaussSolve2(A,B)


% Inizializza il flag di errore
% Controllo sulla dimensione della matrice A e del vettore B.
% Se non ci sono errori, si pu continuare

iflag = errore (A,B);

% Dimensione della matrice
s = size(A);

% Considera il valore delle righe
n=s(1);

% Crea il vettore colonna pivot
for i=1:n
   
   pivot(i,1)=[i];
   
end


% Inizializza il determinante
det = 1;

% k indica il passo dell'algoritmo
for k=1:n-1
    
    % Cerca il massimo mediante la funzione apposita salvandone valore e indice
    % di riga
    [max,ip]=maximus(A,k,pivot,n);

   
   if (max == 0) % NOTA1: significa che sulla diagonale c' uno zero...
      det = 0;   %...per cui il determiniante di una matrice triangolare,
      		     % pari al prodotto degli elementi della diagonale, 
      		     % necessariamente uguale a zero

      iflag = -1; % segnala il verificarsi di una anomalia durante 
      			  % l'applicazione dell'algoritmo:il sistema non
                  %  compatibile
      
      break % Blocca l'esecuzione del programma
               
   end % Fine dell'if
   
   % Scambia effettivamente gli indici nel vettore pivot
   % solo se k  diverso da ip 
   if (ip ~= k)
      
      % Esegui la funzione di scambio
      pivot=scambio(pivot,ip,k);
      
      det = -det; % ad ogni scambio di riga il determinante cambia di segno
   end
   
   % Inizio della decomposizione LU della matrice dei coefficienti
   for i=k+1:n
      
      % Calcola e memorizza il moltiplicatore nella posizione (i,k)
      A(pivot(i),k) = A(pivot(i),k)/A(pivot(k),k);
      
      % Modifica gli elementi della riga i-esima in base al valore del moltiplicatore
      % memorizzato in A(i,k)
      for j=k+1:n
         
          A(pivot(i),j)=A(pivot(i),j)-A(pivot(i),k)*A(pivot(k),j);
          
      end % Fine del ciclo j
            
      % Modifica il valore dei termini noti
      B(pivot(i))=B(pivot(i))-A(pivot(i),k)*B(pivot(k));    
      
  end % fine del ciclo i
   
   % Calcola il determinante moltiplicando gli elementi della diagonale
   % principale della matrice modificata
   det = det * A(pivot(k),k);
   
end; % del ciclo di k

if (A(pivot(n),n) == 0) % Vedi NOTA1
    
    det = 0;
    iflag = -1;
    break
end

% Risoluzione del sistema con back Substitution
[x]=bsLPU(n,A,pivot,B);
